#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//MultiJulia v(0.0.0)Mod01.fsh   by   Chris_M_Thomasson
//https://www.shadertoy.com/view/ltycRz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
Exploding Julia Hyperbolic Vector v:(0.0.0)

by: Chris M. Thomasson
___________________________________*/


// The number of points in the spiral
#define CT_N 16

// Viewport Axes
struct ct_axes
{
    float xmin;
    float xmax;
    float ymin;
    float ymax;
};
    
    
ct_axes ct_axes_from_radius(
    in vec3 vpcircle
){
    return ct_axes(
        vpcircle.x - vpcircle.z,
        vpcircle.x + vpcircle.z,
        vpcircle.y - vpcircle.z,
        vpcircle.y + vpcircle.z
    );
}


// Simple 2d Plane
struct ct_plane2d
{
    ct_axes axes;
    float xstep;
    float ystep;
};
    
    
ct_plane2d ct_plane2d_create(
    in ct_axes axes
){
    float awidth = axes.xmax - axes.xmin;
    float aheight = axes.ymax - axes.ymin;
    
    float daspect = abs(iResolution.y / iResolution.x);
    float waspect = abs(aheight / awidth);
    
    if (daspect > waspect)
    {
        float excess = aheight * (daspect / waspect - 1.0);
        axes.ymax += excess / 2.0;
        axes.ymin -= excess / 2.0;
    }
    
    else if (daspect < waspect)
    {
        float excess = awidth * (waspect / daspect - 1.0);
        axes.xmax += excess / 2.0;
        axes.xmin -= excess / 2.0;
    }
    
    return ct_plane2d(
        axes,
        (axes.xmax - axes.xmin) / iResolution.x,
        (axes.ymax - axes.ymin) / iResolution.y
    );
}


vec2 ct_plane2d_project(
	in ct_plane2d self,
    in vec2 z
){
	return vec2(
        self.axes.xmin + z.x * self.xstep,
        self.axes.ymin + z.y * self.ystep
    );
}


// A vector field point
struct ct_vfpoint
{
    vec2 p;
    float m;
};


// Our global per-pixel points
ct_vfpoint g_vfp[CT_N + 1];


// Gain a normalized vector from p, 
// using a power of npow.
vec2 ct_vfield_normal(
    in vec2 p,
    float npow
){
    float eps = 0.00001;
    vec2 g = vec2(eps, eps);
    
    const int imax = CT_N + 1;
    
    for (int i = 0; i < imax; ++i)
    {
        vec2 dif = g_vfp[i].p - p;
        float sum = dif[0] * dif[0] + dif[1] * dif[1];
        float mass = pow(sum, npow);
        if (mass == 0.0) mass = 0.00001;
        
      	g[0] = g[0] + g_vfp[i].m * dif[0] / mass;
      	g[1] = g[1] + g_vfp[i].m * dif[1] / mass;
    }
    
    return normalize(g);
}


float ct_normal_pi(
    in vec2 z,
    in float sa
){
    float a = atan(z[1], z[0]) + sa;
    if (a < 0.0) a += 6.28318;
    a /= 6.28318;
    return a;
}


vec2 ct_cmul(in vec2 p0, in vec2 p1)
{
    return vec2(p0.x * p1.x - p0.y * p1.y, p0.x * p1.y + p0.y * p1.x);
}


// Vector Pixel Iteration
vec4 ct_vpixel(
    in vec2 z,
    in vec2 c,
    in int n,
    in float npow
){
    float s = 1.0;
    float t = iTime * .1;
    vec2 jc = vec2(-1.6 + abs(cos(iTime * .01)), 0.0);
    vec3 xxxcolor = vec3(0, 0, 0);
    
    vec2 zcopy = z;
    
    // Augment z with some Mandelbrot iterations
    for (int i = 0; i < 9; ++i)
    {
        z = ct_cmul(z, z);
    	z = z + jc;
        
        if (length(z) > 2.0)
        {
            xxxcolor += vec3(float(i) * .07, 0, 0);
            //z = zcopy;
            //break;
            
            float xmin = .14;
            float xmax = .16;
            float xdif = xmax - xmin;
            
            z = z * .01;
        }
        
        else
        {	
            xxxcolor += vec3(.01, .01, .01);
        }
    }

    
    vec2 vn = ct_vfield_normal(z, npow);
    
    float a = 0.0;

    vec2 rc = vec2(
        vn[0] * cos(a) - vn[1] * sin(a),
        vn[0] * sin(a) + vn[1] * cos(a)
    );
    
    float npi = ct_normal_pi(vn, a);
    
    float scale = float(CT_N);
    
    float color = mod(npi * scale, 1.0);
    
    if (color < abs(sin(iTime * .2)) * .05 + .95)
    //if (color < 1.0)
    {
        color = 1.0 - color;
    }
    
    else
    {
        color = 0.0;
    }
    
    return vec4(
        color + (abs(vn.x) * abs(sin(iTime)) * .2),
        color + (abs(vn.y) * abs(cos(iTime)) * .1),
        color + (abs(vn.x * vn.y) * .1),
        1.0
    );

}


vec2 rotate(vec2 v, float a) {
	float s = sin(a);
	float c = cos(a);
	mat2 m = mat2(c, -s, s, c);
	return m * v;
}

// High-Level Entry
vec4 ct_main(
    in ct_plane2d plane,
    in vec2 c
){
    
    const int n = CT_N;
    float scale = 1.0;
    
    float my_time = 0.0;
    
    float r = 0.0;
    
    for (int x = 0; x < n; ++x)
    {
        int y = 0;
        float xr = float(x) / float(n);
        float angle = xr * 6.28 + abs(cos(my_time * .1)) * 1.0;
        
        g_vfp[x] = ct_vfpoint(
            vec2(cos(angle) * r, sin(angle) * r), 
            -1.0
        );
    }
    
    if (iMouse.z > 0.0)
    {
        vec2 cmx = ct_plane2d_project(plane, vec2(iMouse));
        vec2 cm = vec2(0.0, sin(iTime * 3.0) * .4);
        g_vfp[n] = ct_vfpoint(
            cm, 
            1.5
        );
    }
    
    
    vec2 rc = rotate(c, iTime);

    
    return ct_vpixel(rc, rc, 128, 2.0);
}


// Raw Entry.
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3 vpcircle = vec3(
        0, 
        0.0, 
        .01 + abs(sin(iTime * .03)) * 100.0
    );
    
    ct_plane2d plane = ct_plane2d_create(
        ct_axes_from_radius(vpcircle)
    );
    
    vec2 c = ct_plane2d_project(plane, fragCoord);
    
    // Exec...
    vec4 color = ct_main(plane, c);
    
    fragColor = color;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

